<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseCreateHosting extends BaseJob
{
    public int $service_id;
    public int $user_id;
    public string $user_email;
    public string $username;
    public ?string $password;
    public int $server_id;
    public string $domain;
    public string $due_date;
    public string $package_name;
    public bool $wp_auto_setup;
    public InfoInterface $info;

    public function __construct(
        int           $service_id,
        int           $user_id,
        string        $user_email,
        string        $username,
        ?string       $password,
        int           $server_id,
        string        $domain,
        string        $due_date,
        string        $package_name,
        bool          $wp_auto_setup,
        InfoInterface $info
    )
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.create');

        $this->service_id = $service_id;
        $this->user_id = $user_id;
        $this->user_email = $user_email;
        $this->username = $username;
        $this->password = $password;
        $this->server_id = $server_id;
        $this->domain = $domain;
        $this->due_date = $due_date;
        $this->package_name = $package_name;
        $this->wp_auto_setup = $wp_auto_setup;
        $this->info = $info;
    }

    public function handle()
    {
    }
}
