<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\SnapshotInterface;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\RabbitMQ\AutoResolve;

#[AutoResolve('user', 'snapshot')]
class SnapshotDeletedEvent extends BaseJob
{
    public SnapshotInterface $snapshot;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @param SnapshotInterface $snapshot
     * @param ?UserInterface $user
     * @param InfoInterface $info
     */
    public function __construct(SnapshotInterface $snapshot,?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.event.deleted');

        $this->snapshot = $snapshot;
        $this->user = $user;
        $this->info = $info;
    }
}
