<?php

namespace Iranserver\Events\Service;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\RabbitMQ\AutoResolve;

#[AutoResolve('user', 'service')]
class ServiceSuspensionFailedEvent extends BaseJob
{
    public ServiceInterface $service;
    public ?UserInterface $user;
    public InfoInterface $info;
    public string $reason;

    public function __construct(ServiceInterface $service, string $reason, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('service.event.suspension-failed');

        $this->service = $service;
        $this->reason = $reason;
        $this->user = $user;
        $this->info = $info;
    }
}
