<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenStack\ImageInterface;

final class ImageReinstalledEvent extends BaseJob
{
    public int $service_id;
    public ImageInterface $image;
    public InfoInterface $info;

    /**
     * @param int $service_id Hub Host ID
     * @param ImageInterface $image
     * @param InfoInterface $info
     */
    public function __construct(int $service_id, ImageInterface $image, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstalled');

        $this->service_id = $service_id;
        $this->image = $image;
        $this->info = $info;
    }
}
