<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\Openstack\StorageDTO;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenStackBlockStorageDetachJob extends BaseJob
{
    /**
     * @var StorageDTO $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public StorageDTO $storageDTO;
    public InfoInterface $info;

    public int $tries = 3;

    /**
     * Calculate the number of seconds to wait before retrying the job.
     */
    public function backoff(): int
    {
        return 5;
    }

    public function __construct(StorageDTO $storageDTO, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('storage.cmd.detach');

        $this->storageDTO = $storageDTO;
        $this->info = $info;
    }

    public function handle(){}
}