<?php

namespace Iranserver\Events\Addon;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\RabbitMQ\AutoResolve;

#[AutoResolve('user', 'service')]
class AddonSuspendedEvent extends BaseJob
{
    public ServiceInterface $service;
    public ?UserInterface $user;
    public InfoInterface $info;
    public string $reason;

    /**
     * @param string|null $reason
     * @var ServiceInterface $invoice
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold service parameters.
     */
    public function __construct(ServiceInterface $service, ?string $reason, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('addon.event.suspended');

        $this->service = $service;
        $this->reason = $reason;
        $this->user    = $user;
        $this->info    = $info;
    }
}
