<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class HostingSslDeactivationFailedEvent extends BaseJob
{
    public int $service_id;
    public string $reason;
    public InfoInterface $info;

    public function __construct(int $service_id, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.ssl-deactivation-failed');
        $this->service_id = $service_id;
        $this->reason = $reason;
        $this->info = $info;
    }

    public function handle()
    {
    }
}