<?php

namespace Iranserver\Events\Cdn;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\CdnInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;


class CdnSuspendedEvent extends BaseJob
{
    public CdnInterface $cdn;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var CdnInterface $cdn
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(CdnInterface $cdn, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION', 'rabbitmq'));
        $this->onQueue('cdn.event.suspended');

        $this->cdn = $cdn;
        $this->user = $user;
        $this->info = $info;
    }
}
