<?php

namespace Iranserver\Jobs\Service;

use Exception;
use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseServiceSuspendJob extends BaseJob
{
    /**
     * @var int $service_id
     * @var string $service_type
     *
     * Hold user parameters.
     */
    public int $service_id;
    public string $service_type;
    public InfoInterface $info;
    public string $reason;

    /**
     * @param int $service_id
     * @param string $service_type
     * @param string|null $reason
     * @throws \Exception|\Throwable
     * @var InfoInterface $info
     *
     * Hold service parameters.
     */
    public function __construct(int $service_id, string $service_type, ?string $reason, InfoInterface $info)
    {
        throw_if(!in_array($service_type , ["Addon" , "Product"]) , Exception::class , 'Service type should be one of "Product" or "Service"');
        $this->onConnection('rabbitmq');
        $this->onQueue('service.cmd.suspend');

        $this->service_id = $service_id;
        $this->service_type = $service_type;
        $this->reason = $reason;
        $this->info = $info;
    }

    public function handle()
    {
    }
}
