<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseChangePackageHosting extends BaseJob
{
    public InfoInterface $info;
    public int $service_id;
    public string $new_package_name;
    public $tries = 10; //set 10
    public $backoff = 60;//set 60

    public function __construct(int $service_id,string $new_package_name, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.change-package');


        $this->service_id = $service_id;
        $this->new_package_name = $new_package_name;
        $this->info = $info;

    }

    public function handle()
    {
    }
}