<?php

namespace Iranserver\Events\User;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

class SubuserDeletedEvent extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public UserInterface $user;
    public  UserInterface $subuser;
    public InfoInterface $info;

    public function __construct(UserInterface $user, UserInterface $subuser, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('subuser.event.deleted');

        $this->user = $user;
        $this->subuser = $subuser;
        $this->info = $info;
    }
}
