<?php

namespace Iranserver\Events\Service;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;
use Iranserver\Models\Interfaces\UserInterface;


class ServiceSuspensionUpcomingEvent extends BaseJob
{
    public ServiceInterface $service;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var ServiceInterface $invoice
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(ServiceInterface $service, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('service.event.suspension-upcoming');

        $this->service = $service;
        $this->user = $user;
        $this->info    = $info;
    }
}
