<?php

namespace Iranserver\Events\ServiceCustomAction;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class SucceedEvent extends BaseJob
{
    public string $uuid;
    public string $jobType;
    public ?string $jobChainPosition = null;
    public ?string $chainUuid = null;
    public InfoInterface $info;

    public function __construct(string $uuid , string $jobType , ?string $chainUuid , ?string $jobChainPosition , InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('custom-service.event.succeed');

        $this->uuid = $uuid;
        $this->jobType = $jobType;
        $this->chainUuid = $chainUuid;
        $this->jobChainPosition = $jobChainPosition;
        $this->info = $info;
    }
}
