<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenstackInstanceDeleteSnapshot extends BaseJob
{
    public string $snapshot_id;
    public InfoInterface $info;
    public int $tries = 3;

    public function backoff(): int
    {
        return 60;
    }

    /**
     * @param string $snapshot_id
     * @param InfoInterface $info
     */
    public function __construct(string $snapshot_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.cmd.delete');

        $this->snapshot_id = $snapshot_id;
        $this->info = $info;
    }

    public function handle()
    {
    }
}