<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\BlockStorageInterface;
class BlockStorageAttachFailedEvent extends BaseJob
{
    public BlockStorageInterface $blockStorageService;
    public InfoInterface $info;

    /**
     * @param BlockStorageInterface $blockStorageService
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(BlockStorageInterface $blockStorageService, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('storage.event.attach-failed');

        $this->reason = $reason;
        $this->blockStorageService = $blockStorageService;
        $this->info = $info;
    }
}