<?php

namespace Iranserver\Events\Service;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;

class ServiceTerminateFailedEvent extends BaseJob
{
    public ServiceInterface $service;
    public string $reason;
    public InfoInterface $info;

    /**
     * @var ServiceInterface $invoice
     * @var string $reason
     * @var InfoInterface $info
     *
     * Send an event that the head removal was unsuccessful.
     */
    public function __construct(ServiceInterface $service,  string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('service.event.termination-failed');

        $this->service = $service;
        $this->reason = $reason;
        $this->info    = $info;
    }
}
