<?php

namespace Iranserver\Events;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;
use function env;

class UserRegisteredEvent extends BaseJob
{
    protected UserInterface $user;
    protected InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info = null)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('user.event.registered');

        $this->user = $user;
        $this->info = $info;
    }

    public function handle() {}
}