<?php

namespace Iranserver\Jobs\Base\User;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class UserUpdated extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    protected UserInterface $user;
    protected InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('user.event.updated');

        $this->user = $user;
        $this->info = $info;
    }

    public function handle(){}
}
