<?php

namespace Iranserver\Jobs\Base\Ticket;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\TicketInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseTicketCreatedJob extends BaseJob
{
    protected TicketInterface $ticket;
    protected UserInterface $user;
    protected InfoInterface $info;

    /**
     * @var TicketInterface $ticket
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public function __construct(TicketInterface $ticket, UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));

        $this->ticket  = $ticket;
        $this->user    = $user;
        $this->info    = $info;
    }

    public function handle(){}
}
