<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\SnapshotInterface;


class SnapshotDeletedEvent extends BaseJob
{
    public SnapshotInterface $snapshot;
    public InfoInterface $info;

    /**
     * @param SnapshotInterface $snapshot
     * @param InfoInterface $info
     */
    public function __construct(SnapshotInterface $snapshot, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.event.deleted');

        $this->snapshot = $snapshot;
        $this->info = $info;
    }
}
