<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenstackInstanceCreateSnapshot extends BaseJob
{
    /**
     * @var int $service_id
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public int $service_id;
    public string $snapshot_name;
    public InfoInterface $info;

    public int $tries = 17;

    /**
     * Calculate the number of seconds to wait before retrying the job.
     */
    public function backoff(): int
    {
        return 180;
    }

    public function __construct(int $service_id,string $snapshot_name, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.cmd.create');

        $this->service_id = $service_id;
        $this->snapshot_name = $snapshot_name;
        $this->info = $info;
    }

    public function handle()
    {
    }
}