<?php

namespace Iranserver\Traits;

use Iranserver\Middleware\ServiceNotifierMiddleware;

trait ServiceNotifier
{
    /**
     * uuid of job filled by Iranserver\Base\Bus "chain" method
     *
     * @var string|null
     */
    public ?string $chainUuid = null;

    /**
     * it MUST fill with Iranserver\Base\Bus "JOB_CHAIN_POSITION" const values
     *
     * @var string|null
     */
    public ?string $jobChainPosition = null;

    /**
     * get service id of an involved jobs
     *
     * @return int
     */
    abstract public function getServiceId(): int;

    /**
     * get needed payload data to store in service microservice
     *
     * @return array
     */
    public function getPayload(): array
    {
        return [];
    }

    /**
     * @return ServiceNotifierMiddleware[]
     */
    public function middleware()
    {
        return [new ServiceNotifierMiddleware()];
    }

    /**
     * set chain attribute
     *
     * @param string $uuid
     * @param string $jobChainPosition
     * @return void
     */
    public function setChainAttr(string $uuid , string $jobChainPosition)
    {
        $this->chainUuid = $uuid;
        $this->jobChainPosition = $jobChainPosition;
    }
}