<?php

namespace Iranserver\Events\ServiceCustomAction;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;


class CreatingEvent extends BaseJob
{
    public array $payload;
    public int $serviceId;
    public string $uuid;
    public ?string $chainUuid = null;
    public string $jobType;

    public ?string $jobChainPosition = null;

    public InfoInterface $info;
    public function __construct(
        int $serviceId ,
        string $uuid ,
        string $jobType ,
        array $payload ,
        ?string $chainUuid ,
        ?string $jobChainPosition ,
        InfoInterface $info
    ){
        $this->onConnection('rabbitmq');
        $this->onQueue('custom-service.event.creating');

        $this->payload = $payload;
        $this->serviceId = $serviceId;
        $this->chainUuid = $chainUuid;
        $this->jobChainPosition = $jobChainPosition;
        $this->uuid = $uuid;
        $this->jobType = $jobType;
        $this->info = $info;
    }
}
