<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

final class ImageReinstallationFailedEvent extends BaseJob
{
    public int $service_id;
    public string $image_type;
    public string $image_name;
    public string $reason;
    public InfoInterface $info;

    /**
     * @param int $service_id Hub Host ID
     * @param string $image_type Snapshot | OS
     * @param string $image_name Snapshot Name | OS Name
     * @param string $reason Error
     * @param InfoInterface $info
     */
    public function __construct(int $service_id, string $image_type, string $image_name, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstallation-failed');

        $this->service_id = $service_id;
        $this->image_type = $image_type;
        $this->image_name = $image_name;
        $this->reason = $reason;
        $this->info = $info;
    }
}
