<?php

namespace Iranserver\Events\ServiceCustomAction;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class FailedEvent extends BaseJob
{
    public string $uuid;
    public string $jobType;
    public ?string $chainUuid;
    public string $exception;
    public InfoInterface $info;


    public function __construct(string $uuid , string $jobType, ?string $chainUuid, string $exception , InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('custom-service.event.failed');

        $this->uuid = $uuid;
        $this->chainUuid = $chainUuid;
        $this->exception = $exception;
        $this->jobType = $jobType;
        $this->info = $info;
    }
}
