<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

final class ImageReinstalledEvent extends BaseJob
{
    public int $service_id;
    public string $image_type;
    public string $image_name;
    public int $image_size;
    public string $server_password;
    public InfoInterface $info;

    /**
     * @param int $service_id Hub Host ID
     * @param string $image_type Snapshot | OS
     * @param string $image_name Snapshot Name | OS Name
     * @param int $image_size Snapshot Size | OS Size
     * @param string $server_password Server New Password
     * @param InfoInterface $info
     */
    public function __construct(int $service_id, string $image_type, string $image_name, int $image_size, string $server_password, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstalled');

        $this->service_id = $service_id;
        $this->image_type = $image_type;
        $this->image_name = $image_name;
        $this->image_size = $image_size;
        $this->server_password = $server_password;
        $this->info = $info;
    }
}
