<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;

class HostingUnSuspendFailedEvent extends BaseJob
{
    public HostingInterface $hosting;
    public string $reason;
    public InfoInterface $info;

    public function __construct(HostingInterface $hosting, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.unsuspend-failed');
        $this->hosting = $hosting;
        $this->reason = $reason;
        $this->info = $info;

    }

    public function handle()
    {
    }
}