<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenstackInstanceImageReinstall extends BaseJob
{
    public int $service_id;
    public string $image_id;
    public InfoInterface $info;

    public int $tries = 12;

    public function backoff(): int
    {
        return 10;
    }

    public function __construct(int $service_id, string $image_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.cmd.reinstall');

        $this->service_id = $service_id;
        $this->image_id = $image_id;
        $this->info = $info;
    }

    public function handle()
    {
    }
}