<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class SnapshotCreationFailedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public InfoInterface $info;
    public string $reason;


    /**
     * @param OpenstackInterface $openstackService
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService , string $reason ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.event.create-failed');

        $this->openstackService = $openstackService;
        $this->info = $info;
        $this->reason = $reason;
    }
}
