<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

final class ImageReinstallationFailedEvent extends BaseJob
{
    public int $service_id;
    public string $image_type;
    public string $reason;
    public InfoInterface $info;

    public function __construct(int $service_id, string $image_type, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstallation-failed');

        $this->service_id = $service_id;
        $this->image_type= $image_type;
        $this->reason = $reason;
        $this->info = $info;
    }
}
