<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

#[AutoResolve('user', 'hosting')]
class HostingPackageChangeFailedEvent extends BaseJob
{
    public HostingInterface $hosting;
    public string $new_package;
    public string $failure_message;
    public InfoInterface $info;
    public ?UserInterface $user;

    public function __construct(HostingInterface $hosting, string $new_package, string $failure_message, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.package-change-failed');

        $this->hosting = $hosting;
        $this->new_package = $new_package;
        $this->failure_message = $failure_message;
        $this->info = $info;
        $this->user = $user;

    }

    public function handle()
    {
    }
}