<?php

namespace Iranserver\Jobs\Ticket;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\TicketInterface;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseAddNoteTicketJob extends BaseJob
{
    public TicketInterface $ticket;
    public InfoInterface $info;
    public string $note;
    public bool $isMarkDown;

    public function __construct(TicketInterface $ticket,string $note,bool $isMarkDown,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('ticket.cmd.note');

        $this->ticket = $ticket;
        $this->note = $note;
        $this->isMarkDown = $isMarkDown;
        $this->info = $info;
    }
}