<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class InstanceTrafficOverusedEvent extends BaseJob
{
    public int $service_id;
    public InfoInterface $info;

    /**
     * @var OpenstackInterface $openstackService
     * @param InfoInterface $info
     *
     *
     */
    public function __construct(int $service_id ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('instance.event.traffic-overused');

        $this->service_id = $service_id;
        $this->info = $info;
    }
}
