<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

final class ImageReinstalledEvent extends BaseJob
{
    public int $service_id;
    public InfoInterface $info;

    public function __construct(int $service_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstalled');

        $this->service_id = $service_id;
        $this->info = $info;
    }
}
