<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

final class ImageReinstallationFailedEvent extends BaseJob
{
    public int $service_id;
    public string $reason;
    public InfoInterface $info;

    public function __construct(int $service_id, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstallation-failed');

        $this->service_id = $service_id;
        $this->reason = $reason;
        $this->info = $info;
    }
}
