<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class InstanceTrafficOverusedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public InfoInterface $info;

    /**
     * @var OpenstackInterface $openstackService
     * @param InfoInterface $info
     *
     *
     */
    public function __construct(OpenstackInterface $openstackService ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('instance.event.traffic-overused');

        $this->openstackService = $openstackService;
        $this->info = $info;
    }
}
