<?php

namespace Iranserver\Jobs\Ticket;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\TicketDTO;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenTicketJob extends BaseJob
{
    public TicketDTO $ticketDTO;
    public InfoInterface $info;

    public function __construct(TicketDTO $ticketDTO,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('ticket.cmd.open');

        $this->ticketDTO = $ticketDTO;
        $this->info = $info;
    }

}