<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\BlockStorageInterface;

class BlockStorageDetachedEvent extends BaseJob
{
    public BlockStorageInterface $blockStorageService;
    public InfoInterface $info;

    /**
     * @param BlockStorageInterface $blockStorageService
     * @param InfoInterface $info
     */
    public function __construct(BlockStorageInterface $blockStorageService ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('storage.event.detached');

        $this->blockStorageService = $blockStorageService;
        $this->info = $info;
    }

}