<?php

namespace Iranserver\Events\Ticket;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\TicketInterface;
use Iranserver\Models\Interfaces\TicketReplyInterface;
use Iranserver\Models\Interfaces\UserInterface;


class TicketCreatedEvent extends BaseJob
{
    public TicketInterface $ticket;
    public TicketReplyInterface $ticketReply;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var TicketInterface $ticket
     * @var TicketReplyInterface $ticketReply
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public function __construct(TicketInterface $ticket,TicketReplyInterface $ticketReply,?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('ticket.event.created');


        $this->ticket  = $ticket;
        $this->ticketReply = $ticketReply;
        $this->user    = $user;
        $this->info    = $info;
    }
}
