<?php

namespace Iranserver\Jobs\Base\OAuth;

use Iranserver\Jobs\BaseJob;

class UserLogin extends BaseJob
{
    /**
     * @var array
     *
     * Hold user parameters
     *
     * array['username'] username | string
     * array['scopes'] scopes | array
     * array['client_id'] client id | int
     * array['time'] login time | Carbon
     */
    protected array $params;

    public function __construct(array $params)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('user.event.login');

        $this->params = $params;
    }

    public function handle()
    {

    }
}
