<?php

namespace Iranserver\Jobs\Base\Credit;

use Iranserver\Jobs\BaseJob;

abstract class BaseCreditLoweredJob extends BaseJob
{
    protected string $providerName;
    protected array $data;

    /**
     * @var string $providerName
     * @var array $data
     *
     * Hold credit parameters.
     */
    public function __construct(string $providerName,array $data)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));

        $this->providerName = $providerName;
        $this->data         = $data;
    }

    public function handle(){}
}
