<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;

abstract class BaseOpenstackInstanceUnSuspendJob extends BaseJob
{
    /**
     * @var ServiceInterface $service
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public ServiceInterface $service;
    public InfoInterface $info;

    public int $tries = 17;

    /**
     * Calculate the number of seconds to wait before retrying the job.
     */
    public function backoff(): int
    {
        return 180;
    }

    public function __construct(ServiceInterface $service, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('instance.cmd.unsuspend');

        $this->service = $service;
        $this->info = $info;
    }

    public function handle()
    {
    }
}