<?php

namespace Iranserver\WebSockets;

class NotificationWebSocket extends WebSocket
{
    protected function getSenders(): array
    {
        return ['service'];
    }

    protected function getPayloadRules(): array
    {
        return [
            'message' => 'required|string',
            'type' => 'required|string|in:info,warning,error',
        ];
    }

    protected function getType(): string
    {
        return 'notification';
    }
}