<?php

namespace Iranserver\Jobs\Service;

use Exception;
use Iranserver\Base\BaseJob;

abstract class BaseServiceSuspendJob extends BaseJob
{
    /**
     * @var int $service_id
     * @var string $service_type
     *
     * Hold user parameters.
     */
    public int $service_id;
    public string $service_type;

    public function __construct(int $service_id, string $service_type)
    {
        throw_if(!in_array($service_type , ["Addon" , "Product"]) , Exception::class , 'Service type should be one of "Product" or "Service"');
        $this->onConnection('rabbitmq');
        $this->onQueue('service.cmd.suspend');

        $this->service_type = $service_type;
        $this->service_id = $service_id;
    }

    public function handle()
    {
    }
}
