<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;
#[AutoResolve('user', 'hosting')]
class HostingPackageChangedEvent extends BaseJob
{
    public HostingInterface $hosting;
    public InfoInterface $info;
    public ?UserInterface $user;



    public function __construct(HostingInterface $hosting, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.package-changed');


        $this->hosting = $hosting;
        $this->info = $info;
        $this->user = $user;
    }
}
