<?php

namespace Iranserver\Jobs\Cdn;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\CdnDTO;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseSuspendCdnJob extends BaseJob
{
    public CdnDTO $cdnDTO;
    public InfoInterface $info;

    public $tries = 10;
    public $backoff = 60;
    public function __construct(CdnDTO $cdnDTO, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION', 'rabbitmq'));
        $this->onQueue('cdn.cmd.suspend');

        $this->cdnDTO = $cdnDTO;
        $this->info = $info;
    }

    public function handle()
    {
    }
}
