<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;

class HostingTerminatedEvent extends BaseJob
{
    public HostingInterface $hosting;
    public InfoInterface $info;


    public function __construct(HostingInterface $hosting, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.terminated');


        $this->hosting = $hosting;
        $this->info = $info;
    }

    public function handle()
    {
    }
}
