<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\Openstack\StorageDTO;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenStackBlockStorageTerminateJob extends BaseJob
{
    /**
     * @var StorageDTO $storageDTO
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public StorageDTO $storageDTO;
    public InfoInterface $info;

    public int $tries = 17;

    /**
     * Calculate the number of seconds to wait before retrying the job.
     */
    public function backoff(): int
    {
        return 180;
    }

    public function __construct(StorageDTO $storageDTO, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('storage.cmd.terminate');

        $this->storageDTO = $storageDTO;
        $this->info = $info;
    }

    public function handle()
    {
    }
}