<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseResetHosting extends BaseJob
{
    public int $service_id;
    public InfoInterface $info;

    public $tries = 10;
    public $backoff = 60;

    public function __construct(int $service_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.reset');
        $this->service_id = $service_id;
        $this->info = $info;

    }

    public function handle()
    {
    }
}