<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseChangePasswordHosting extends BaseJob
{
    public InfoInterface $info;
    public int $service_id;
    public string $new_password;
    public $tries = 1; //set 10
    public $backoff = 60;//set 60

    public function __construct(int $service_id,string $new_password, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.change-password');


        $this->service_id = $service_id;
        $this->new_password = $new_password;
        $this->info = $info;

    }

    public function handle()
    {
    }
}